/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.mygdx.game.AiBoat;
import com.mygdx.game.ArrrghGame;
import com.mygdx.game.Boat;
import com.mygdx.game.Port;
import com.mygdx.game.Screens.PortMenu;

public class WorldContactListener
implements ContactListener {
    ArrrghGame game;
    public boolean isCollided = false;
    public boolean isDocked = false;
    public boolean firstCollision = false;

    public WorldContactListener(ArrrghGame game) {
        this.game = game;
    }

    @Override
    public void beginContact(Contact contact) {
        Fixture fix1 = contact.getFixtureA();
        Fixture fiz2 = contact.getFixtureB();
        if (contact.getFixtureA().getUserData() instanceof Port || contact.getFixtureB().getUserData() instanceof Port) {
            if (contact.getFixtureA().getUserData() instanceof Boat || contact.getFixtureB().getUserData() instanceof Boat) {
                this.PlayerDocks(contact);
            }
            if (contact.getFixtureA().getUserData() instanceof Port) {
                Port collidedport = (Port)contact.getFixtureA().getUserData();
            } else {
                Port port = (Port)contact.getFixtureB().getUserData();
            }
        } else if (contact.getFixtureA().getUserData() instanceof Boat || contact.getFixtureB().getUserData() instanceof Boat) {
            this.isCollided = true;
            this.firstCollision = true;
        } else if (contact.getFixtureA().getUserData() instanceof AiBoat || contact.getFixtureB().getUserData() instanceof AiBoat) {
            this.AiCollision(contact);
        }
    }

    @Override
    public void endContact(Contact contact) {
        this.isCollided = false;
        this.isDocked = false;
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    private void AiCollision(Contact contact) {
        Fixture fix1 = contact.getFixtureA();
        Fixture fiz2 = contact.getFixtureB();
        AiBoat collidedBoat = fix1.getUserData() instanceof AiBoat ? (AiBoat)fix1.getUserData() : (AiBoat)fiz2.getUserData();
        collidedBoat.collision();
    }

    private void PlayerDocks(Contact contact) {
        Boat player = this.game.currentgame.pboat;
        Port dock = this.game.currentgame.port_constantine;
        if (contact.getFixtureA().getUserData() instanceof Boat) {
            player = (Boat)contact.getFixtureA().getUserData();
            dock = (Port)contact.getFixtureB().getUserData();
        } else if (contact.getFixtureB().getUserData() instanceof Boat) {
            player = (Boat)contact.getFixtureA().getUserData();
            dock = (Port)contact.getFixtureB().getUserData();
        }
        this.game.currentgame.goals.test(dock.allegiance);
        if (dock.allegiance != this.game.currentgame.playerCollege) {
            return;
        }
        this.isDocked = true;
        player.body.setLinearVelocity(0.0f, 0.0f);
        if (this.game.currentgame.control.interact) {
            this.game.currentgame.control.interact = false;
            this.game.currentgame.control.down = false;
            this.game.currentgame.control.up = false;
            this.game.currentgame.control.left = false;
            this.game.currentgame.control.right = false;
            this.game.setScreen(new PortMenu(this.game));
        }
    }
}

