/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class Tutorials
implements Disposable {
    public Stage stage;
    private Viewport viewport;
    SpriteBatch batch = new SpriteBatch();
    private Label tutorialLabel;
    private String tip = "Hey there Sailor! Press the arrow keys to navigate the choppy waters of York!";

    public Tutorials() {
        this.viewport = new FitViewport(300.0f, 300.0f, new OrthographicCamera());
        this.stage = new Stage(this.viewport);
        Table table = new Table();
        table.top();
        table.setFillParent(true);
        BitmapFont font = new BitmapFont();
        this.tutorialLabel = new Label((CharSequence)this.tip, new Label.LabelStyle(font, Color.WHITE));
        font.getData().setScale(0.5f);
        table.add(this.tutorialLabel).expandX().padTop(90.0f);
        this.stage.addActor(table);
    }

    public void removeTip() {
        this.tip = "";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForPoints() {
        this.tip = "The more dangerous your actions the more points you'll get... but be careful, Sailor!";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForPorts() {
        this.tip = "Mmmm a port... Make contact with your colleges port and press 'e' - ";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForEnemy() {
        this.tip = "Cutlasses! That ship doesn't look too friendly...";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForTime() {
        this.tip = "Shiver Me Timbers! The clock's ticking, Sailor...";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForHealth() {
        this.tip = "You're pretty healthy right now Sailor, but don't go sinking our ship!";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForCollisions() {
        this.tip = "Monkeys! You've run aground. I'd avoid colliding into cliffs if you like smooth sailing!";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForTimeUp() {
        this.tip = "Monkeys! You're out of time...";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForSinking() {
        this.tip = "You sunk our ship. You're clearly not ready for the high seas, Sailor!";
        this.tutorialLabel.setText(this.tip);
    }

    public void updateTipForWin() {
        this.tip = "Skull and Cross Bones! You've gone and won. Well done sailor...";
        this.tutorialLabel.setText(this.tip);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }
}

