/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mygdx.game.AiBoat;
import com.mygdx.game.ArrrghGame;
import com.mygdx.game.Boat;
import com.mygdx.game.Castle;
import com.mygdx.game.College;
import com.mygdx.game.Enums;
import com.mygdx.game.GoalManager;
import com.mygdx.game.Hud;
import com.mygdx.game.Neesa;
import com.mygdx.game.Port;
import com.mygdx.game.Screens.EndScreen;
import com.mygdx.game.Tutorials;
import com.mygdx.game.UserInputManager;
import com.mygdx.game.WorldContactListener;
import com.mygdx.game.map.Campus_east;
import com.mygdx.game.map.PhysicsWorld;
import com.mygdx.game.map.Tile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MAIN
extends ScreenAdapter {
    public ArrrghGame game;
    SpriteBatch batch;
    Texture img;
    OrthographicCamera camera;
    public UserInputManager control;
    PhysicsWorld box2D;
    private int displaywidth;
    private int displayheight;
    private Hud hud;
    private Tutorials tut;
    private int exitTime;
    private int collideTime;
    private int tipstart;
    private int tipend;
    private WorldContactListener contact;
    public Enums.COLLEGE playerCollege;
    private boolean seenCollideTut;
    private boolean seenHealthTut;
    private boolean haveBeenClose;
    int x;
    int y;
    public GoalManager goals;
    int direction_x;
    int direction_y;
    int speed = 3;
    Campus_east map;
    public Boat pboat;
    public Port port_lister;
    public Port port_goodricke;
    public Port port_langwith;
    public Port port_constantine;
    Neesa neesa;
    Castle castle_lister;
    Castle castle_goodrike;
    Castle castle_langwith;
    Castle castle_constantine;
    College Goodricke;
    College Lister;
    College Langwith;
    College Constantine;
    AiBoat goodricke1;
    AiBoat constantine1;
    AiBoat langwith1;
    AiBoat lister1;

    public MAIN(ArrrghGame game, Enums.COLLEGE playerCollege) {
        this.game = game;
        this.batch = new SpriteBatch();
        this.playerCollege = playerCollege;
        this.img = new Texture("badlogic.jpg");
        this.displaywidth = Gdx.graphics.getWidth();
        this.displayheight = Gdx.graphics.getHeight();
        this.goals = new GoalManager();
        int h = (int)((double)this.displayheight / Math.floor(this.displayheight / 160));
        int w = (int)((double)this.displaywidth / ((double)this.displayheight / ((double)this.displayheight / Math.floor(this.displayheight / 160))));
        this.camera = new OrthographicCamera(w, h);
        this.camera.zoom = 0.4f;
        this.control = new UserInputManager(this.displaywidth, this.displayheight, this.camera);
        this.control = new UserInputManager(this.displaywidth, this.displayheight, this.camera);
        Gdx.input.setInputProcessor(this.control);
        this.box2D = new PhysicsWorld();
        this.map = new Campus_east(this.box2D);
        this.createColleges();
        this.pboat = new Boat(this.map.pSpawnCoords, this.box2D, playerCollege);
        this.goodricke1 = new AiBoat(this.map.aispawn_goodricke1, this.box2D, Enums.COLLEGE.GOODRICKE);
        this.constantine1 = new AiBoat(this.map.aispawn_constantine1, this.box2D, Enums.COLLEGE.CONSTANTINE);
        this.langwith1 = new AiBoat(this.map.aispawn_langwith1, this.box2D, Enums.COLLEGE.LANGWITH);
        this.lister1 = new AiBoat(this.map.aispawn_lister1, this.box2D, Enums.COLLEGE.LISTER);
        this.contact = new WorldContactListener(game);
        this.port_lister = new Port(this.map.portlisterCoords, this.box2D, Enums.COLLEGE.LISTER);
        this.port_goodricke = new Port(this.map.portgoodrickeCoords, this.box2D, Enums.COLLEGE.GOODRICKE);
        this.port_langwith = new Port(this.map.portlangwithCoords, this.box2D, Enums.COLLEGE.LANGWITH);
        this.port_constantine = new Port(this.map.portconstantineCoords, this.box2D, Enums.COLLEGE.CONSTANTINE);
        this.castle_lister = new Castle(this.map.castleListerCoords, this.box2D, 1);
        this.castle_goodrike = new Castle(this.map.castleGoodrickeCoords, this.box2D, 2);
        this.castle_langwith = new Castle(this.map.castleLangwithCoords, this.box2D, 3);
        this.castle_constantine = new Castle(this.map.castleConstantineCoords, this.box2D, 4);
        this.neesa = new Neesa(this.map.neesaCoords, this.box2D);
        this.box2D.world.setContactListener(this.contact);
        this.hud = new Hud();
        this.tut = new Tutorials();
        this.tipstart = 0;
        this.collideTime = 0;
        this.seenHealthTut = false;
        this.seenCollideTut = false;
        this.haveBeenClose = false;
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.control);
    }

    @Override
    public void render(float delta) {
        boolean endWin;
        super.render(delta);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.pboat.update(this.control);
        this.goodricke1.update();
        this.constantine1.update();
        this.langwith1.update();
        this.lister1.update();
        this.camera.position.lerp(this.pboat.position, 0.1f);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.setBlendFunction(770, 771);
        this.batch.begin();
        for (ArrayList<Tile> row : this.map.tempchunk.tiles) {
            for (Tile tile : row) {
                this.batch.draw(tile.texture, tile.position.x, tile.position.y, (float)tile.size, (float)tile.size);
            }
        }
        this.pboat.draw(this.batch);
        this.goodricke1.draw(this.batch);
        this.constantine1.draw(this.batch);
        this.langwith1.draw(this.batch);
        this.lister1.draw(this.batch);
        this.port_lister.draw(this.batch);
        this.port_langwith.draw(this.batch);
        this.port_constantine.draw(this.batch);
        this.port_goodricke.draw(this.batch);
        this.castle_lister.draw(this.batch);
        this.castle_langwith.draw(this.batch);
        this.castle_constantine.draw(this.batch);
        this.castle_goodrike.draw(this.batch);
        this.neesa.draw(this.batch);
        this.batch.end();
        this.box2D.tick(this.camera, this.control);
        this.hud.updateTime();
        this.hud.stage.draw();
        this.tut.stage.draw();
        this.tipend = this.tipstart + 4;
        if (this.tipend == this.hud.getTime()) {
            this.tut.removeTip();
        }
        if (this.hud.getTime() == 4) {
            this.tut.updateTipForTime();
        }
        if (this.hud.getTime() == 8) {
            this.tut.updateTipForPoints();
        }
        MAIN mAIN = this;
        if (mAIN.hud.getHealth() < 80 && this.seenHealthTut) {
            this.tipstart = this.hud.getTime();
            this.tut.updateTipForHealth();
            this.seenHealthTut = true;
        }
        if (this.hud.getTime() == 12) {
            this.tipstart = this.hud.getTime();
            this.tut.updateTipForPorts();
        }
        if (this.contact.firstCollision && !this.seenCollideTut) {
            this.tipstart = this.hud.getTime();
            this.tut.updateTipForCollisions();
            this.seenCollideTut = true;
        }
        if (!this.haveBeenClose && this.closeness()) {
            this.tipstart = this.hud.getTime();
            this.tut.updateTipForEnemy();
        }
        if (this.hud.isScoreWin() && this.goals.goalsCompleted()) {
            this.tut.updateTipForWin();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, true));
            }
        }
        if (this.hud.isTimeUp()) {
            this.tut.updateTipForTimeUp();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, false));
            }
        }
        if (this.hud.isSunk()) {
            this.tut.updateTipForSinking();
            this.pboat.sinkShip();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, false));
            }
        }
        if (!this.haveBeenClose && this.closeness()) {
            this.tipstart = this.hud.getTime();
            this.tut.updateTipForEnemy();
        }
        if (this.goals.goalsCompleted()) {
            this.hud.visitedAll();
        }
        boolean bl = endWin = this.hud.isScoreWin() && this.goals.goalsCompleted();
        if (endWin) {
            this.tut.updateTipForWin();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, true));
            }
        }
        if (this.hud.isTimeUp()) {
            this.tut.updateTipForTimeUp();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, false));
            }
        }
        if (this.hud.isSunk()) {
            this.tut.updateTipForSinking();
            this.pboat.sinkShip();
            this.exitTime = this.hud.getFinishTime();
            if (this.exitTime == this.hud.getTime()) {
                this.game.setScreen(new EndScreen(this.game, false));
            }
        }
        if (this.contact.isCollided && this.hud.getTime() > this.collideTime + 1) {
            this.collideTime = this.hud.getTime();
            this.hud.addHealth((int)(-(Math.random() * 15.0)));
        }
        if (this.contact.isDocked && this.hud.getTime() > this.collideTime + 1) {
            MAIN mAIN2 = this;
            if (mAIN2.hud.getHealth() < 100) {
                this.collideTime = this.hud.getTime();
                this.hud.addHealth(1);
            }
        }
        if (this.closeness()) {
            this.haveBeenClose = true;
            this.hud.setDanger(true);
        } else {
            this.hud.setDanger(false);
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.img.dispose();
        this.hud.dispose();
        this.tut.dispose();
    }

    @Override
    public void hide() {
        Gdx.input.setInputProcessor(null);
    }

    private void createColleges() {
        this.Goodricke = new College("Goodricke", Enums.COLLEGE.GOODRICKE);
        this.Lister = new College("Lister", Enums.COLLEGE.LISTER);
        this.Langwith = new College("Langwith", Enums.COLLEGE.LANGWITH);
        this.Constantine = new College("Constantine", Enums.COLLEGE.CONSTANTINE);
        this.Goodricke.relationships.put(this.Lister, Enums.RELATIONSHIP.ENEMY);
        this.Goodricke.relationships.put(this.Langwith, Enums.RELATIONSHIP.ENEMY);
        this.Goodricke.relationships.put(this.Constantine, Enums.RELATIONSHIP.ENEMY);
        this.Lister.relationships.put(this.Goodricke, Enums.RELATIONSHIP.ENEMY);
        this.Lister.relationships.put(this.Langwith, Enums.RELATIONSHIP.ENEMY);
        this.Lister.relationships.put(this.Constantine, Enums.RELATIONSHIP.ENEMY);
        this.Langwith.relationships.put(this.Goodricke, Enums.RELATIONSHIP.ENEMY);
        this.Langwith.relationships.put(this.Lister, Enums.RELATIONSHIP.ENEMY);
        this.Langwith.relationships.put(this.Constantine, Enums.RELATIONSHIP.ENEMY);
        this.Constantine.relationships.put(this.Goodricke, Enums.RELATIONSHIP.ENEMY);
        this.Constantine.relationships.put(this.Lister, Enums.RELATIONSHIP.ENEMY);
        this.Constantine.relationships.put(this.Langwith, Enums.RELATIONSHIP.ENEMY);
    }

    private boolean closeness() {
        HashMap<College, Enums.RELATIONSHIP> bob = null;
        if (this.playerCollege == Enums.COLLEGE.CONSTANTINE) {
            bob = this.Constantine.relationships;
        } else if (this.playerCollege == Enums.COLLEGE.LISTER) {
            bob = this.Lister.relationships;
        } else if (this.playerCollege == Enums.COLLEGE.LANGWITH) {
            bob = this.Langwith.relationships;
        } else if (this.playerCollege == Enums.COLLEGE.GOODRICKE) {
            bob = this.Goodricke.relationships;
        }
        float x = this.pboat.getXPosition();
        float y = this.pboat.getYPosition();
        boolean close = false;
        for (Map.Entry<College, Enums.RELATIONSHIP> entry : bob.entrySet()) {
            float minusY;
            float minusX;
            double distance;
            College key = entry.getKey();
            Enums.RELATIONSHIP value = entry.getValue();
            float aiX = 0.0f;
            float aiY = 0.0f;
            if (value != Enums.RELATIONSHIP.ENEMY) continue;
            if (key.enumField == Enums.COLLEGE.CONSTANTINE) {
                aiX = this.constantine1.getXPosition();
                aiY = this.constantine1.getYPosition();
            } else if (key.enumField == Enums.COLLEGE.LANGWITH) {
                aiX = this.langwith1.getXPosition();
                aiY = this.langwith1.getYPosition();
            } else if (key.enumField == Enums.COLLEGE.GOODRICKE) {
                aiX = this.goodricke1.getXPosition();
                aiY = this.goodricke1.getYPosition();
            } else if (key.enumField == Enums.COLLEGE.LISTER) {
                aiX = this.lister1.getXPosition();
                aiY = this.lister1.getYPosition();
            }
            if (!((distance = Math.sqrt((minusX = aiX - x) * minusX + (minusY = aiY - y) * minusY)) < 25.0)) continue;
            close = true;
        }
        return close;
    }
}

