/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.mygdx.game.ArrrghGame;
import com.mygdx.game.Screens.TitleScreen;

public class EndScreen
extends ScreenAdapter {
    ArrrghGame game;
    private Stage stage;
    private Texture playBtn;
    private Texture background;
    private Texture titleTexture;
    private Image title;
    private boolean playerWin;

    public EndScreen(ArrrghGame game, Boolean win) {
        this.game = game;
        this.playerWin = win;
        this.background = new Texture("bg-1.png");
        this.playBtn = new Texture("placeholder.png");
        this.stage = new Stage(new ScreenViewport());
        Gdx.input.setInputProcessor(this.stage);
        if (this.playerWin) {
            this.titleTexture = new Texture(Gdx.files.internal("winning_screen.png"));
            this.title = new Image(this.titleTexture);
        } else {
            this.titleTexture = new Texture(Gdx.files.internal("losing_screen.png"));
            this.title = new Image(this.titleTexture);
        }
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Skin skin = new Skin(Gdx.files.internal("skin/metal-ui.json"));
        TextButton playbtn = new TextButton("Return To menu", skin);
        TextButton exitbtn = new TextButton("Exit", skin);
        table.add(this.title);
        table.background(new TextureRegionDrawable(new TextureRegion(new Texture("bg-1.png"))));
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.add(playbtn).fillX().uniformX();
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.add(exitbtn).fillX().uniformX();
        playbtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EndScreen.this.game.setScreen(new TitleScreen(EndScreen.this.game));
            }
        });
        exitbtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Gdx.app.exit();
            }
        });
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.25f, 0.25f, 0.25f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void hide() {
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }
}

