/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.mygdx.game.ArrrghGame;
import com.mygdx.game.Enums;
import com.mygdx.game.Screens.MAIN;

public class CollegeSelector
extends ScreenAdapter {
    ArrrghGame game;
    private Stage stage;
    private Texture playBtn;
    private Texture background;
    private Texture titleTexture;
    private Image title;
    private Label label;

    public CollegeSelector(ArrrghGame game) {
        this.game = game;
        this.background = new Texture("bg-1.png");
        this.playBtn = new Texture("placeholder.png");
        this.stage = new Stage(new ScreenViewport());
        Gdx.input.setInputProcessor(this.stage);
        this.titleTexture = new Texture(Gdx.files.internal("piratequest.png"));
        this.title = new Image(this.titleTexture);
    }

    @Override
    public void show() {
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        Skin skin = new Skin(Gdx.files.internal("skin/metal-ui.json"));
        this.label = new Label((CharSequence)"So what do you say, Sailor? Pick a college to swear allegiance to!", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        TextButton playbtn = new TextButton("Play", skin);
        final SelectBox<String> selectBox = new SelectBox<String>(skin);
        selectBox.setItems("Select College", "Goodricke", "Langwith", "Constantine", "Anne Lister");
        table.add(this.title);
        table.background(new TextureRegionDrawable(new TextureRegion(new Texture("bg-1.png"))));
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.add(this.label).fillX().uniformX();
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.add(selectBox).fillX().uniformX();
        table.row().pad(10.0f, 0.0f, 10.0f, 0.0f);
        table.add(playbtn).fillX().uniformX();
        playbtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Enums.COLLEGE chosenCollege = Enums.COLLEGE.GOODRICKE;
                switch ((String)selectBox.getSelected()) {
                    case "Select College": {
                        return;
                    }
                    case "Goodricke": {
                        chosenCollege = Enums.COLLEGE.GOODRICKE;
                        break;
                    }
                    case "Langwith": {
                        chosenCollege = Enums.COLLEGE.LANGWITH;
                        break;
                    }
                    case "Constantine": {
                        chosenCollege = Enums.COLLEGE.CONSTANTINE;
                        break;
                    }
                    case "Anne Lister": {
                        chosenCollege = Enums.COLLEGE.LISTER;
                    }
                }
                CollegeSelector.this.game.currentgame = new MAIN(CollegeSelector.this.game, chosenCollege);
                CollegeSelector.this.game.setScreen(CollegeSelector.this.game.currentgame);
            }
        });
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.25f, 0.25f, 0.25f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
        this.stage.draw();
    }

    @Override
    public void hide() {
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }
}

