/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;

public class Hud
implements Disposable {
    public Stage stage;
    private Viewport viewport;
    private Integer maxTime = 300;
    private float timePassed = 0.0f;
    private boolean timeOver;
    private Integer finishTime;
    private static Integer timer;
    private static Integer winScore;
    private static Integer score;
    private static boolean haveWon;
    private boolean dangermode;
    private String goalOneComplete = "INCOMPLETE";
    private String goalTwoComplete = "INCOMPLETE";
    private boolean visitedAll;
    private static boolean isSunk;
    private static Integer health;
    private static Integer gold;
    private Label timeLabel;
    private Label timeTextLabel;
    private Label scoreTextLabel;
    private Label goldTextLabel;
    private static Label scoreLabel;
    private static Label goldLabel;
    private static Label healthLabel;
    private static Label healthTextLabel;
    private static Label goalOneLabel;
    private static Label goalTwoLabel;
    private static Label goalLabel;
    private static Label goalOneCriteria;
    private static Label goalTwoCriteria;

    public Hud() {
        timer = 0;
        this.finishTime = 5;
        this.timeOver = false;
        score = 0;
        winScore = 1000;
        haveWon = false;
        this.dangermode = false;
        this.visitedAll = false;
        health = 100;
        isSunk = false;
        gold = 0;
        this.viewport = new FitViewport(300.0f, 300.0f, new OrthographicCamera());
        this.stage = new Stage(this.viewport);
        this.timeLabel = new Label((CharSequence)String.format("%03d", timer), new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        scoreLabel = new Label((CharSequence)String.format("%04d", score), new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goldLabel = new Label((CharSequence)String.format("%04d", gold), new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        healthLabel = new Label((CharSequence)String.format("%03d", health), new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        this.timeTextLabel = new Label((CharSequence)"TIME PASSED", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        this.scoreTextLabel = new Label((CharSequence)"POINTS", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        this.goldTextLabel = new Label((CharSequence)"GOLD", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        healthTextLabel = new Label((CharSequence)"HEALTH", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goalLabel = new Label((CharSequence)"GOALS", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goalOneLabel = new Label((CharSequence)"GET 1000 POINTS:", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goalTwoLabel = new Label((CharSequence)"VISIT ALL COLLEGES:", new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goalOneCriteria = new Label((CharSequence)this.goalOneComplete, new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        goalTwoCriteria = new Label((CharSequence)this.goalTwoComplete, new Label.LabelStyle(new BitmapFont(), Color.WHITE));
        Table table = new Table();
        table.top();
        table.setFillParent(true);
        table.add(this.scoreTextLabel).expandX().padTop(10.0f);
        table.add(this.timeTextLabel).expandX().padTop(10.0f);
        table.add(this.goldTextLabel).expandX().padTop(10.0f);
        table.add(healthTextLabel).expandX().padTop(10.0f);
        table.row();
        table.add(scoreLabel).expandX();
        table.add(this.timeLabel).expandX();
        table.add(goldLabel).expandX();
        table.add(healthLabel).expandX();
        this.stage.addActor(table);
        Table goalTable = new Table();
        goalTable.bottom();
        goalTable.left();
        goalTable.setFillParent(true);
        goalTable.add(goalLabel).expandX().padTop(10.0f);
        goalTable.row();
        goalTable.add(goalOneLabel).expandX().padTop(10.0f);
        goalTable.add(goalOneCriteria).expandX().padTop(10.0f);
        goalTable.row();
        goalTable.add(goalTwoLabel).expandX().padTop(10.0f);
        goalTable.add(goalTwoCriteria).expandX().padTop(10.0f);
        this.stage.addActor(goalTable);
    }

    public void updateTime() {
        this.timePassed += 1.0f;
        if (this.timePassed == 60.0f) {
            if (this.maxTime < timer) {
                if (!this.timeOver) {
                    this.finishTime = this.finishTime + timer;
                }
                this.timeOver = true;
            }
            Integer n = timer;
            Integer n2 = timer = Integer.valueOf(timer + 1);
            this.timePassed = 0.0f;
            if (!(this.timeOver || haveWon && this.visitedAll || isSunk)) {
                this.timeLabel.setText(String.format("%03d", timer));
                if (this.dangermode) {
                    this.addScore((int)(Math.random() * 11.0));
                } else {
                    this.addScore((int)(Math.random() * 6.0));
                }
            }
        }
    }

    public void addScore(int value) {
        score = score + value;
        scoreLabel.setText(String.format("%06d", score));
        if (score >= winScore) {
            if (!haveWon || !this.visitedAll) {
                this.finishTime = this.finishTime + timer;
            }
            haveWon = true;
            this.goalOneComplete = "COMPLETE";
            goalOneCriteria.setText(this.goalOneComplete);
        }
    }

    public void setDanger(boolean danger) {
        this.dangermode = danger;
    }

    public static void addGold(int value) {
        gold = gold + value;
        goldLabel.setText(String.format("%06d", gold));
    }

    public void addHealth(int value) {
        if (!isSunk) {
            health = health + value;
        }
        if (health <= 0) {
            if (!isSunk) {
                this.finishTime = this.finishTime + timer;
            }
            isSunk = true;
            health = 0;
            healthLabel.setText(String.format("%03d", health));
        } else if (health > 0) {
            healthLabel.setText(String.format("%03d", health));
        }
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public boolean isTimeUp() {
        return this.timeOver;
    }

    public boolean isScoreWin() {
        return haveWon;
    }

    public static Integer getGold() {
        return gold;
    }

    public Integer getFinishTime() {
        return this.finishTime;
    }

    public Integer getTime() {
        return timer;
    }

    public static Integer getHealth() {
        return health;
    }

    public boolean isSunk() {
        return isSunk;
    }

    public void visitedAll() {
        this.visitedAll = true;
        this.goalTwoComplete = "COMPLETE";
        goalTwoCriteria.setText(this.goalTwoComplete);
    }
}

