/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.mygdx.game.Enums;

public class Entity {
    public Vector3 position = new Vector3();
    public Texture texture;
    public float width;
    public float height;
    public Enums.ENTITYTYPE type;
    public float speed;
    public Body body;
    public Fixture fixture;

    public void draw(SpriteBatch batch) {
        batch.draw(this.texture, this.position.x, this.position.y, this.width, this.height);
    }

    public void createBody(World world, float width, float height, Vector3 pos, BodyDef.BodyType type) {
        BodyDef bodyDef = new BodyDef();
        bodyDef.position.set(pos.x + width / 2.0f, pos.y + height / 2.0f);
        bodyDef.angle = 0.0f;
        bodyDef.fixedRotation = true;
        bodyDef.type = type;
        this.body = world.createBody(bodyDef);
        FixtureDef fixtureDef = new FixtureDef();
        PolygonShape boxShape = new PolygonShape();
        boxShape.setAsBox(width / 2.0f, height / 2.0f);
        fixtureDef.shape = boxShape;
        fixtureDef.restitution = 0.4f;
        this.fixture = this.body.createFixture(fixtureDef);
        this.fixture.setUserData(this);
        boxShape.dispose();
    }
}

