/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.mygdx.game.Entity;
import com.mygdx.game.Enums;
import com.mygdx.game.UserInputManager;
import com.mygdx.game.map.PhysicsWorld;

public class Boat
extends Entity {
    int direction_x;
    int direction_y;
    private char lastD;
    private boolean verticle;
    private boolean sunk = false;
    private String folder;
    private Texture movingUp;
    private Texture movingDown;
    private Texture movingLeft;
    private Texture movingRight;
    private Texture stationaryUp;
    private Texture stationaryDown;
    private Texture stationaryLeft;
    private Texture stationaryRight;
    private Texture dead;

    public Boat(Vector3 pos, PhysicsWorld box2d, Enums.COLLEGE college) {
        this.type = Enums.ENTITYTYPE.BOAT;
        this.width = 8.0f;
        this.height = 12.0f;
        this.position.x = pos.x;
        this.position.y = pos.y;
        this.speed = 30.0f;
        this.createBody(box2d.world, this.width - 5.0f, this.height, pos, BodyDef.BodyType.DynamicBody);
        if (college == Enums.COLLEGE.LISTER) {
            this.texture = new Texture("red_boat/stationary_up.png");
        } else if (college == Enums.COLLEGE.CONSTANTINE) {
            this.texture = new Texture("purple_boat/stationary_up.png");
        } else if (college == Enums.COLLEGE.GOODRICKE) {
            this.texture = new Texture("green_boat/stationary_up.png");
        } else if (college == Enums.COLLEGE.LANGWITH) {
            this.texture = new Texture("yellow_boat/stationary_up.png");
        }
        switch (college) {
            case LISTER: {
                this.folder = "red_boat/";
                break;
            }
            case CONSTANTINE: {
                this.folder = "purple_boat/";
                break;
            }
            case GOODRICKE: {
                this.folder = "green_boat/";
                break;
            }
            case LANGWITH: {
                this.folder = "yellow_boat/";
            }
        }
        this.loadTextures();
    }

    public void update(UserInputManager control) {
        this.direction_x = 0;
        this.direction_y = 0;
        Boolean prevVerticle = this.verticle;
        if (!this.sunk) {
            if (control.down) {
                this.direction_y = -1;
                this.width = 8.0f;
                this.height = 12.0f;
                this.texture = this.movingDown;
                this.lastD = (char)68;
                this.verticle = true;
            } else if (control.up) {
                this.direction_y = 1;
                this.width = 8.0f;
                this.height = 12.0f;
                this.texture = this.movingUp;
                this.lastD = (char)85;
                this.verticle = true;
            } else if (control.left) {
                this.direction_x = -1;
                this.width = 12.0f;
                this.height = 8.0f;
                this.texture = this.movingLeft;
                this.lastD = (char)76;
                this.verticle = false;
            } else if (control.right) {
                this.direction_x = 1;
                this.width = 12.0f;
                this.height = 8.0f;
                this.texture = this.movingRight;
                this.lastD = (char)82;
                this.verticle = false;
            } else {
                this.width = 8.0f;
                this.height = 12.0f;
                switch (this.lastD) {
                    case 'U': {
                        this.width = 8.0f;
                        this.height = 12.0f;
                        this.texture = this.stationaryUp;
                        break;
                    }
                    case 'D': {
                        this.width = 8.0f;
                        this.height = 12.0f;
                        this.texture = this.stationaryDown;
                        break;
                    }
                    case 'L': {
                        this.width = 12.0f;
                        this.height = 8.0f;
                        this.texture = this.stationaryLeft;
                        break;
                    }
                    case 'R': {
                        this.width = 12.0f;
                        this.height = 8.0f;
                        this.texture = this.stationaryRight;
                    }
                }
            }
        }
        this.body.setLinearVelocity((float)this.direction_x * this.speed, (float)this.direction_y * this.speed);
        this.position.x = this.body.getPosition().x - this.width / 2.0f;
        this.position.y = this.body.getPosition().y - this.height / 4.0f;
    }

    private void loadTextures() {
        this.movingUp = new Texture(this.folder + "up.png");
        this.movingDown = new Texture(this.folder + "down.png");
        this.movingLeft = new Texture(this.folder + "left.png");
        this.movingRight = new Texture(this.folder + "right.png");
        this.stationaryUp = new Texture(this.folder + "stationary_up.png");
        this.stationaryDown = new Texture(this.folder + "stationary_down.png");
        this.stationaryLeft = new Texture(this.folder + "stationary_left.png");
        this.stationaryRight = new Texture(this.folder + "stationary_right.png");
        this.dead = new Texture(this.folder + "dead.png");
    }

    public void sinkShip() {
        this.width = 12.0f;
        this.height = 8.0f;
        this.texture = this.dead;
        this.sunk = true;
    }

    public float getXPosition() {
        return this.position.x;
    }

    public float getYPosition() {
        return this.position.y;
    }
}

