/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.mygdx.game.Entity;
import com.mygdx.game.Enums;
import com.mygdx.game.map.PhysicsWorld;

public class AiBoat
extends Entity {
    int direction_x;
    int direction_y;
    private char lastD;
    int colour = 0;

    public AiBoat(Vector3 pos, PhysicsWorld box2d, Enums.COLLEGE college) {
        this.type = Enums.ENTITYTYPE.BOAT;
        this.width = 8.0f;
        this.height = 12.0f;
        if (college == Enums.COLLEGE.GOODRICKE) {
            this.colour = 1;
        } else if (college == Enums.COLLEGE.CONSTANTINE) {
            this.colour = 2;
        } else if (college == Enums.COLLEGE.LANGWITH) {
            this.colour = 3;
        } else if (college == Enums.COLLEGE.LISTER) {
            this.colour = 4;
        }
        this.position.x = pos.x;
        this.position.y = pos.y;
        this.speed = 10.0f;
        this.createBody(box2d.world, this.width - 5.0f, this.height, pos, BodyDef.BodyType.DynamicBody);
        EdgeShape sight = new EdgeShape();
        this.direction_x = (int)Math.floor(Math.random() * 3.0) + -1;
        this.direction_y = (int)Math.floor(Math.random() * 3.0) + -1;
    }

    public void update() {
        int randX = (int)Math.floor(Math.random() * 3.0) + -1;
        int randY = (int)Math.floor(Math.random() * 3.0) + -1;
        if (Math.floor(Math.random() * 1001.0 + 0.0) > 975.0) {
            if (Math.floor(Math.random() * 101.0 + 0.0) > 50.0) {
                this.direction_y = randY;
                this.direction_x = 0;
            } else {
                this.direction_x = randX;
                this.direction_y = 0;
            }
        }
        if (this.direction_x != 0) {
            if (this.direction_x == 1) {
                this.width = 12.0f;
                this.height = 8.0f;
                if (this.colour == 1) {
                    this.texture = new Texture("green_boat/right.png");
                } else if (this.colour == 2) {
                    this.texture = new Texture("purple_boat/right.png");
                } else if (this.colour == 3) {
                    this.texture = new Texture("yellow_boat/right.png");
                } else if (this.colour == 4) {
                    this.texture = new Texture("red_boat/right.png");
                }
            } else {
                this.width = 12.0f;
                this.height = 8.0f;
                if (this.colour == 1) {
                    this.texture = new Texture("green_boat/left.png");
                } else if (this.colour == 2) {
                    this.texture = new Texture("purple_boat/left.png");
                } else if (this.colour == 3) {
                    this.texture = new Texture("yellow_boat/left.png");
                } else if (this.colour == 4) {
                    this.texture = new Texture("red_boat/left.png");
                }
            }
        } else if (this.direction_y == 1) {
            this.width = 8.0f;
            this.height = 12.0f;
            if (this.colour == 1) {
                this.texture = new Texture("green_boat/up.png");
            } else if (this.colour == 2) {
                this.texture = new Texture("purple_boat/up.png");
            } else if (this.colour == 3) {
                this.texture = new Texture("yellow_boat/up.png");
            } else if (this.colour == 4) {
                this.texture = new Texture("red_boat/up.png");
            }
        } else {
            this.width = 8.0f;
            this.height = 12.0f;
            if (this.colour == 1) {
                this.texture = new Texture("green_boat/down.png");
            } else if (this.colour == 2) {
                this.texture = new Texture("purple_boat/down.png");
            } else if (this.colour == 3) {
                this.texture = new Texture("yellow_boat/down.png");
            } else if (this.colour == 4) {
                this.texture = new Texture("red_boat/down.png");
            }
        }
        this.body.setLinearVelocity((float)this.direction_x * this.speed, (float)this.direction_y * this.speed);
        this.position.x = this.body.getPosition().x - this.width / 2.0f;
        this.position.y = this.body.getPosition().y - this.height / 4.0f;
    }

    public void collision() {
        this.direction_x *= -1;
        this.direction_y *= -1;
    }

    public float getXPosition() {
        return this.position.x;
    }

    public float getYPosition() {
        return this.position.y;
    }
}

