/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class PooledEngine
extends Engine {
    private EntityPool entityPool;
    private ComponentPools componentPools;

    public PooledEngine() {
        this(10, 100, 10, 100);
    }

    public PooledEngine(int entityPoolInitialSize, int entityPoolMaxSize, int componentPoolInitialSize, int componentPoolMaxSize) {
        this.entityPool = new EntityPool(entityPoolInitialSize, entityPoolMaxSize);
        this.componentPools = new ComponentPools(componentPoolInitialSize, componentPoolMaxSize);
    }

    @Override
    public Entity createEntity() {
        return (Entity)this.entityPool.obtain();
    }

    @Override
    public <T extends Component> T createComponent(Class<T> componentType) {
        return (T)((Component)this.componentPools.obtain(componentType));
    }

    public void clearPools() {
        this.entityPool.clear();
        this.componentPools.clear();
    }

    @Override
    protected void removeEntityInternal(Entity entity) {
        super.removeEntityInternal(entity);
        if (entity instanceof PooledEntity) {
            this.entityPool.free((PooledEntity)entity);
        }
    }

    private class ComponentPools {
        private ObjectMap<Class<?>, ReflectionPool> pools = new ObjectMap();
        private int initialSize;
        private int maxSize;

        public ComponentPools(int initialSize, int maxSize) {
            this.initialSize = initialSize;
            this.maxSize = maxSize;
        }

        public <T> T obtain(Class<T> type) {
            ReflectionPool<T> pool = this.pools.get(type);
            if (pool == null) {
                pool = new ReflectionPool<T>(type, this.initialSize, this.maxSize);
                this.pools.put(type, pool);
            }
            return pool.obtain();
        }

        public void free(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            ReflectionPool pool = this.pools.get(object.getClass());
            if (pool == null) {
                return;
            }
            pool.free(object);
        }

        public void freeAll(Array objects) {
            if (objects == null) {
                throw new IllegalArgumentException("objects cannot be null.");
            }
            int n = objects.size;
            for (int i = 0; i < n; ++i) {
                Object object = objects.get(i);
                if (object == null) continue;
                this.free(object);
            }
        }

        public void clear() {
            for (Pool pool : this.pools.values()) {
                pool.clear();
            }
        }
    }

    private class EntityPool
    extends Pool<PooledEntity> {
        public EntityPool(int initialSize, int maxSize) {
            super(initialSize, maxSize);
        }

        @Override
        protected PooledEntity newObject() {
            return new PooledEntity();
        }
    }

    private class PooledEntity
    extends Entity
    implements Pool.Poolable {
        private PooledEntity() {
        }

        @Override
        public Component remove(Class<? extends Component> componentClass) {
            Component component = super.remove(componentClass);
            if (component != null) {
                PooledEngine.this.componentPools.free(component);
            }
            return component;
        }

        @Override
        public void reset() {
            this.removeAll();
            this.flags = 0;
            this.componentAdded.removeAllListeners();
            this.componentRemoved.removeAllListeners();
            this.scheduledForRemoval = false;
            this.removing = false;
        }
    }
}

